library(scales)

plotDirectory = 'D:/Manuscripts/Chapter 3 - Fivash et al. 2020 Annals of Botany/Figure 6 - Results of Soil oxygen experiment/Figure components/'
inputDirectory = 'D:/Manuscripts/Chapter 3 - Fivash et al. 2020 Annals of Botany/Figure 6 - Results of Soil oxygen experiment/CSV/'

setwd(plotDirectory)

tiff("Figure 6b.tif",
     width = 8, height = 6,
     units = 'in', res = 300)
par (mar = c(5,5,4,4))
setwd(inputDirectory)

sedimentSeq = c('Lowered','Flat','Raised')
colSeq = c('yellow', 'green','blue')
for(i in 1:3){
  sediment = sedimentSeq[i]
  col = colSeq[i]
  setwd(inputDirectory)
  if(sediment == 'Lowered'){
    #Hollow (E6)
    d = read.csv('hollowOxygenExp.csv')
    tide = read.csv('hollowTide.csv')
  }
  
  if(sediment == 'Flat'){
    #Flat (E1)
    d = read.csv('flatOxygenExp.csv')
    tide = read.csv('flatTide.csv')
  }
  
  if(sediment == 'Raised'){
    #Hummock (E5)
    d = read.csv('hummockOxygenExp.csv')
    tide = read.csv('hummockTide.csv')
  }
  
  d$time = as.POSIXct(d$time)
  tide$time = as.POSIXct(tide$time)
  
  # plot(-d$oxygenDeclineRate ~ d$time, pch = 20, cex = 0.2)
  # polygon(tide$highTide*100 ~ tide$time, col = alpha('blue',0.5), lty = 0)
  
  windowSize = 1
  n_windows = floor(length(d$oxygenDeclineRate.method_1)/windowSize)
  rate = c()
  time = c()
  
  for(window in 1:n_windows){
    start = 1 + windowSize*(window - 1)
    end = windowSize*window
    
    rate[window] = mean(-d$oxygenDeclineRate.method_1[start:end], na.rm = T)
    time[window] = mean(d$time[start:end])
  }
  # if(sediment == 'Raised'){
  # filter = c(286:498)
  # rate[filter] = NA
  # }
  time = as.POSIXct(time, origin = '1970-01-01')
  
  tideOnsetSeq = tide$time[diff(tide$highTide) == 1]
  rateSeries = c()
  timeSeries = c()
  tideSeries = c()
  initialTide = 1
  
  for(i_tide in initialTide:(length(tideOnsetSeq) - 1)){
    start = time > tideOnsetSeq[i_tide] - 500
    end = time <= tideOnsetSeq[i_tide + 1] - 500
    timeStep = seq(0, unique(diff(tideOnsetSeq)), length.out = length(rate[start & end]))
    tideStep = rep(0, times = length(timeStep))
    tideStep[timeStep <= 3] = 1
    
    rateSeries = c(rateSeries,rate[start & end])
    timeSeries = c(timeSeries,timeStep)
    tideSeries = c(tideSeries,tideStep)
  }
  
  roundTimeSeries = round(timeSeries, digits = 10)
  meanRateSeries = tapply(rateSeries, roundTimeSeries, mean, na.rm = T)
  meanTideSeries = tapply(tideSeries, roundTimeSeries, mean, na.rm = T)
  uniqueTimeSeries = tapply(timeSeries,roundTimeSeries, mean, na.rm = T)
  
  setwd(plotDirectory)
  if(sediment == 'Lowered'){
    plot(rateSeries ~ timeSeries, pch = 20, cex = 0.5, col = alpha(col,0.5), ylim = c(0, 6),
         ylab = 'Decline rate of soil oxygen availability', xlab = 'Time since onset of high tide (hours)')
    polygon(c(0,meanTideSeries)*6 ~ c(0,uniqueTimeSeries), lty = 0, col = alpha('blue',0.2))
    lines(meanRateSeries ~ uniqueTimeSeries, type = 'l', lwd = 4, col = alpha(col,0.75))
    # text(x = 1.5, y = 5.6, 'High Tide')
    # text(x = 7.5, y = 5.6, 'Low Tide')

  } else {
    points(rateSeries ~ timeSeries, pch = 20, cex = 0.5, col = alpha(col,0.5))
    lines(meanRateSeries ~ uniqueTimeSeries, type = 'l', lwd = 4, col = alpha(col,0.75))
  }
}
text('Flood: Arrival of oxygen-rich flood', x = 2.3, y = 5.7, cex = 0.8)
text('water into deep sediment layers', x = 2.3, y = 5.45, cex = 0.8)
arrows(x0 = 0.2, x1 = 0.5, y0 = 5.5, y1 = 4, lwd = 3, length = 0.1)

text('Water-saturated soil is deoxygenated', x = 4.4, y = 1, cex = 0.8)
text('by microbial consumption', x = 4.4, y = 0.75, cex = 0.8)
arrows(x0 = 2.1, x1 = 3.3, y0 = 1.1, y1 = 2.5, lwd = 3, length = 0.1)

#text('B', x = 11.8, y = 5.8, cex = 1.5)
legend(y = 1.1, x = 10.1,
       legend = sedimentSeq, fill = alpha(colSeq,0.5), bty = 'n', cex = 0.9)
setwd(plotDirectory)
dev.off()
